@extends('layouts.app')

@section('title', $ticket->subject)

@section('content')
<div class="ticket-show-page">
    <div class="container">
        <div class="ticket-header-section">
            <h1>{{ $ticket->subject }}</h1>
            <div class="ticket-meta-info">
                <span class="badge badge-{{ $ticket->status }}">{{ ucfirst($ticket->status) }}</span>
                <span class="badge badge-priority-{{ $ticket->priority }}">{{ ucfirst($ticket->priority) }} Priority</span>
                <span>Created: {{ $ticket->created_at->format('M d, Y H:i') }}</span>
            </div>
        </div>

        <div class="ticket-main">
            <div class="ticket-description">
                <h3>Description</h3>
                <p>{{ $ticket->description }}</p>
                
                @if($ticket->attachments->where('ticket_reply_id', null)->count() > 0)
                    <div class="attachments">
                        <h4>Attachments</h4>
                        <ul>
                            @foreach($ticket->attachments->where('ticket_reply_id', null) as $attachment)
                                <li>
                                    <a href="{{ asset('storage/' . $attachment->file_path) }}" target="_blank">
                                        {{ $attachment->file_name }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>

            <div class="ticket-replies">
                <h3>Replies ({{ $ticket->replies->count() }})</h3>
                
                @foreach($ticket->replies as $reply)
                    <div class="reply-card">
                        <div class="reply-header">
                            <strong>{{ $reply->user->name }}</strong>
                            <span>{{ $reply->created_at->format('M d, Y H:i') }}</span>
                        </div>
                        <div class="reply-message">
                            {{ $reply->message }}
                        </div>
                        @if($reply->attachments->count() > 0)
                            <div class="attachments">
                                <h4>Attachments</h4>
                                <ul>
                                    @foreach($reply->attachments as $attachment)
                                        <li>
                                            <a href="{{ asset('storage/' . $attachment->file_path) }}" target="_blank">
                                                {{ $attachment->file_name }}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endsection

